<?php

function cache_path($key){
  return __DIR__."/../cache/".$key.".json";
}

function cache_get($key){
  $f = cache_path($key);

  if(!file_exists($f)) return false;
  if(time() - filemtime($f) > CACHE_TTL) return false;

  $data = file_get_contents($f);

  // cegah cache kosong / rusak
  if($data === false || trim($data) === ''){
    @unlink($f);
    return false;
  }

  return $data;
}

function cache_set($key,$data){
  $f = cache_path($key);

  // pastikan folder ada & writable
  $dir = dirname($f);
  if(!is_dir($dir)){
    mkdir($dir,0755,true);
  }

  // write atomic (ANTI RACE CONDITION)
  $tmp = $f.'.tmp';
  $bytes = file_put_contents($tmp, $data, LOCK_EX);

  if($bytes === false || $bytes === 0){
    error_log("CACHE WRITE FAILED: ".$f);
    return false;
  }

  rename($tmp, $f);
  return true;
}

function cache_delete($key){
  $f = cache_path($key);
  if(file_exists($f)) unlink($f);
}
