<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require __DIR__.'/../config/config.php';
require __DIR__.'/../config/db.php';
require __DIR__.'/cache.php';

header('Content-Type: application/json; charset=utf-8');

$domain = preg_replace('/^www\./','',$_GET['domain'] ?? '');
$slug   = $_GET['slug'] ?? '';

if(!$domain || !$slug){
  http_response_code(400);
  echo json_encode(['error'=>'invalid_param']);
  exit;
}

/* CACHE */
$key = md5($domain.$slug);
if($json = cache_get($key)){
  echo $json;
  exit;
}

/* DOMAIN */
$d = $db->prepare("SELECT id,domain,template,status FROM domains WHERE domain=? AND status=1 LIMIT 1");
$d->bind_param("s",$domain);
$d->execute();
$d->bind_result($did,$domain_db,$template,$status);
$d->fetch();
$d->close();

if(!$domain_db){
  http_response_code(404);
  echo json_encode(['error'=>'domain_not_found']);
  exit;
}

/* PAGE */
$p = $db->prepare("
 SELECT p.slug, r.seo_title, r.seo_description, r.banner
 FROM pages p
 JOIN page_result r ON r.page_id=p.id
 WHERE p.slug=? LIMIT 1
");
$p->bind_param("s",$slug);
$p->execute();
$p->bind_result($slug_db,$seo_title,$seo_description,$banner);
$p->fetch();
$p->close();

if(!$slug_db){
  http_response_code(404);
  echo json_encode(['error'=>'page_not_found']);
  exit;
}

/* RESPONSE */
$response = [
  'brand' => BRAND_NAME,
  'domain' => $domain_db,
  'template' => $template,
  'slug' => $slug_db,
  'seo' => [
    'title' => $seo_title,
    'description' => $seo_description
  ],
  'banner' => CDN_URL.'/'.$banner
];

$json = json_encode($response, JSON_UNESCAPED_UNICODE);

if($json === false){
  echo json_encode([
    'error' => 'json_encode_failed',
    'last_error' => json_last_error_msg(),
    'raw_response' => $response
  ]);
  exit;
}

if(empty($json)){
  echo json_encode([
    'error'=>'json_empty',
    'response'=>$response
  ]);
  exit;
}

cache_set($key,$json);
echo $json;

